clear all
cd "H:\Colombe\requests from OB\R&D and hysteresis"

import excel "H:\Colombe\requests from OB\R&D and hysteresis\R&D.xlsx", sheet("Stata ") firstrow
format date %td
gen year=year(date)

gen lnGDP=ln(RGDP)
gen lnRD=ln(RD_real)
gen RCP=NCP/GDP_deflator
gen lnCP=ln(RCP)


tsset year


***ln RD on ln GDP
forval i=1/8 {
reg lnRD l(0/`i').lnGDP 
estat dwatson
eststo, addscalars(dw r(dw) nb_reg r(k))
}
esttab using lnRDlnGDP.csv, cells(b(star fmt(2)) t(fmt(2))) stats(r2 N dw nb_reg)  ///
 plain title("Expenditures in R&D on distributed lags of GDP - level, logs, 1953-2013") replace 

eststo clear

***ln RD on ln GDP - first diff
forval i=1/8 {
reg d.(lnRD l(0/`i').lnGDP) 
estat dwatson
eststo, addscalars(dw r(dw) nb_reg r(k))
}
esttab using lnRDlnGDP.csv, cells(b(star fmt(2)) t(fmt(2))) stats(r2 N dw nb_reg)  /// 
 plain title("Expenditures in R&D on distributed lags of GDP - first difference, 1953-2013") append

eststo clear

***ln RD on ln CP
forval i=1/8 {
reg lnRD l(0/`i').lnCP 
estat dwatson
eststo, addscalars(dw r(dw) nb_reg r(k))
}
esttab using lnRDlnCP.csv, cells(b(star fmt(2)) t(fmt(2))) stats(r2 N dw nb_reg)  /// 
plain title("Expenditures in R&D on distributed lags of corporate profits - level, logs, 1953-2013") replace 

eststo clear

***ln RD on ln CP - first diff
forval i=1/8 {
reg d.(lnRD l(0/`i').lnCP) 
estat dwatson
eststo, addscalars(dw r(dw) nb_reg r(k))
}
esttab using lnRDlnCP.csv, cells(b(star fmt(2)) t(fmt(2))) stats(r2 N dw nb_reg)  /// 
plain title("Expenditures in R&D on distributed lags of corporate profits - first difference, 1953-2013") append

eststo clear

